/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.powerbuilder.jdbc;

import com.sybase.powerbuilder.jdbc.PbjdbcError;
import com.sybase.powerbuilder.jdbc.PbjdbcExecuteThreadResult;
import com.sybase.powerbuilder.jdbc.PbjdbcTrace;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PbjdbcExecuteThread
extends Thread {
    PreparedStatement m_Statement;
    PbjdbcExecuteThreadResult m_Result;

    public PbjdbcExecuteThread(PreparedStatement preparedStatement, PbjdbcExecuteThreadResult pbjdbcExecuteThreadResult) {
        this.m_Statement = preparedStatement;
        this.m_Result = pbjdbcExecuteThreadResult;
    }

    @Override
    public void run() {
        try {
            if (this.m_Statement.execute()) {
                ResultSet resultSet = this.m_Statement.getResultSet();
                this.m_Result.SetResultSet(resultSet);
            } else {
                Integer n = new Integer(this.m_Statement.getUpdateCount());
                this.m_Result.SetUpdateCount(n);
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcExecuteThread::run SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            PbjdbcError pbjdbcError = new PbjdbcError(sQLException);
            this.m_Result.SetError(pbjdbcError);
        }
    }
}

