/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.powerbuilder.jdbc;

import com.sybase.powerbuilder.jdbc.PbjdbcError;
import com.sybase.powerbuilder.jdbc.PbjdbcExecuteThread;
import com.sybase.powerbuilder.jdbc.PbjdbcExecuteThreadResult;
import com.sybase.powerbuilder.jdbc.PbjdbcRowSet;
import com.sybase.powerbuilder.jdbc.PbjdbcTrace;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;

public class PbjdbcCommand {
    public static final int sm_Empty = 0;
    public static final int sm_Prepared = 1;
    public static final int sm_Callable = 2;
    protected String m_szCommand;
    protected int m_StatementType;
    protected Statement m_Statement;
    protected ResultSet m_ResultSet;
    protected Integer m_UpdateCount;
    protected Calendar m_Calendar;
    protected Hashtable m_Hashtable;
    protected PbjdbcError m_Error;
    PbjdbcExecuteThread m_ExecThread;
    PbjdbcExecuteThreadResult m_ExecResult;
    Method m_mthdCursor;
    int m_iTotalCursors;
    int m_iCurrentCursor;

    protected PbjdbcCommand() {
        this.m_szCommand = null;
        this.m_StatementType = 0;
        this.m_Statement = null;
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Calendar = Calendar.getInstance();
        this.m_Error = null;
        this.m_mthdCursor = null;
        this.m_iTotalCursors = 0;
        this.m_iCurrentCursor = 0;
        this.m_Hashtable = new Hashtable();
    }

    public PbjdbcCommand(Statement statement) {
        this.m_szCommand = null;
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Calendar = Calendar.getInstance();
        this.m_Error = null;
        this.m_StatementType = 0;
        this.m_Statement = statement;
        this.m_mthdCursor = null;
        this.m_iTotalCursors = 0;
        this.m_iCurrentCursor = 0;
        this.m_Hashtable = new Hashtable();
    }

    public PbjdbcCommand(String string, int n, Statement statement) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Calendar = Calendar.getInstance();
        this.m_Error = null;
        this.m_szCommand = string;
        this.m_StatementType = n;
        this.m_Statement = statement;
        this.m_mthdCursor = null;
        this.m_iTotalCursors = 0;
        this.m_iCurrentCursor = 0;
        this.m_Hashtable = new Hashtable();
    }

    public int CloseStatement() {
        try {
            if (this.m_ResultSet != null) {
                this.m_ResultSet.close();
                this.m_ResultSet = null;
            }
            this.m_Statement.close();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::CloseStatement SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetDecimal(int n, String string) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDecimal Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            ((PreparedStatement)this.m_Statement).setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDecimal SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetASEDecimal(int n, String string, int n2, int n3) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDecimal Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            Class<?> clazz = Class.forName("com.sybase.jdbcx.SybCallableStatement");
            Class[] classArray = new Class[]{Integer.TYPE, BigDecimal.class, Integer.TYPE, Integer.TYPE};
            Method method = clazz.getMethod("setBigDecimal", classArray);
            Object[] objectArray = new Object[]{new Integer(n), bigDecimal, new Integer(n2), new Integer(n3)};
            method.invoke((Object)this.m_Statement, objectArray);
        }
        catch (Exception exception) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDecimal Exception thrown");
            this.m_Error = new PbjdbcError(999, exception.toString());
            return -1;
        }
        return 0;
    }

    public int SetString(int n, String string) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetString Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setString(n, string);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetString SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetDouble(int n, double d) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDouble Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setDouble(n, d);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDouble SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetFloat(int n, float f) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetFloat Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setFloat(n, f);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetFloat SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetLong(int n, long l) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetLong Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setLong(n, l);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetLong SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetInt(int n, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetInt Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setInt(n, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetInt SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetShort(int n, short s) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetShort Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setShort(n, s);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetShort SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetDate(int n, int n2, int n3, int n4) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDate Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            this.m_Calendar.clear();
            this.m_Calendar.set(n2, n3, n4);
            Date date = new Date(this.m_Calendar.getTime().getTime());
            ((PreparedStatement)this.m_Statement).setDate(n, date);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetDate SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetTime(int n, int n2, int n3, int n4, int n5) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetTime Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            this.m_Calendar.clear();
            this.m_Calendar.set(1970, 0, 1, n2, n3, n4);
            if (n5 > 0) {
                this.m_Calendar.set(14, n5 / 1000);
            }
            Time time = new Time(this.m_Calendar.getTime().getTime());
            ((PreparedStatement)this.m_Statement).setTime(n, time);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetTime SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetTimestamp Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            this.m_Calendar.clear();
            this.m_Calendar.set(n2, n3, n4, n5, n6, n7);
            if (n8 != 0) {
                this.m_Calendar.set(14, n8 / 1000);
            }
            Timestamp timestamp = new Timestamp(this.m_Calendar.getTime().getTime());
            ((PreparedStatement)this.m_Statement).setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetTimestamp SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetBinaryStream(int n, InputStream inputStream, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetBinaryStream Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetBinaryStream SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetAsciiStream(int n, InputStream inputStream, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetAsciiStream Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetAsciiStream SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetClob(int n, String string, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetClob Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            StringReader stringReader = new StringReader(string);
            ((PreparedStatement)this.m_Statement).setCharacterStream(n, (Reader)stringReader, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetClob SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetBinary(int n, byte[] byArray) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetBinary Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetBinary SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int SetNull(int n, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetNull Cannot set parm on empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot set parm on empty statement.");
            return -1;
        }
        try {
            ((PreparedStatement)this.m_Statement).setNull(n, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::SetNull SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int RegisterOutCursor(int n, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::RegisterOutParameter Can only register cursor on Callable Statement");
            this.m_Error = new PbjdbcError(2, "Can only register curosr on Callable Statement.");
            return -1;
        }
        try {
            ((CallableStatement)this.m_Statement).registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::RegisterOutCurosr SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        if (this.m_iCurrentCursor == 0) {
            this.m_iCurrentCursor = n;
        }
        ++this.m_iTotalCursors;
        return 0;
    }

    public int RegisterOutParameter(int n, int n2) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::RegisterOutParameter Can only register outparm on Callable Statement");
            this.m_Error = new PbjdbcError(2, "Can only register outparm on Callable Statement.");
            return -1;
        }
        try {
            ((CallableStatement)this.m_Statement).registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::RegisterOutParameter SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int RegisterOutParameter(int n, int n2, int n3) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::RegisterOutParameter Can only register outparm on Callable Statement");
            this.m_Error = new PbjdbcError(2, "Can only register outparm on Callable Statement.");
            return -1;
        }
        try {
            ((CallableStatement)this.m_Statement).registerOutParameter(n, n2, n3);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::RegisterOutParameter SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public long GetParmLong(int n) throws NullPointerException, SQLException {
        long l;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmLong No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            l = ((CallableStatement)this.m_Statement).getLong(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmLong SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return l;
    }

    public int GetParmInt(int n) throws NullPointerException, SQLException {
        int n2;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmInt No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            n2 = ((CallableStatement)this.m_Statement).getInt(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmInt SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n2;
    }

    public short GetParmShort(int n) throws NullPointerException, SQLException {
        short s;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmShort No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            s = ((CallableStatement)this.m_Statement).getShort(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmShort SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return s;
    }

    public float GetParmFloat(int n) throws NullPointerException, SQLException {
        float f;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmFloat No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            f = ((CallableStatement)this.m_Statement).getFloat(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmFloat SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return f;
    }

    public double GetParmDouble(int n) throws NullPointerException, SQLException {
        double d;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmDouble No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            d = ((CallableStatement)this.m_Statement).getDouble(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmDouble SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return d;
    }

    public String GetParmString(int n) throws NullPointerException, SQLException {
        this.m_Error = null;
        String string = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmString No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            string = ((CallableStatement)this.m_Statement).getString(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmString SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        if (string == null) {
            string = new String("");
        }
        return string;
    }

    public String GetParmDecimal(int n) throws NullPointerException, SQLException {
        this.m_Error = null;
        BigDecimal bigDecimal = null;
        String string = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmDecimal No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            bigDecimal = ((CallableStatement)this.m_Statement).getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetParmDecimal SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        string = bigDecimal != null ? bigDecimal.toString() : new String("");
        return string;
    }

    public short GetYear(int n, int n2) throws NullPointerException, SQLException {
        short s;
        this.m_Error = null;
        int n3 = 0;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetYear No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        n3 = timestamp.getNanos();
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        if (this.m_Calendar.get(14) != 0 || (n3 /= 1000000) <= 0) break;
                        this.m_Calendar.set(14, n3);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetYear Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            s = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (short)0 : (short)this.m_Calendar.get(1);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetYear SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return s;
    }

    public byte GetMonth(int n, int n2) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetMonth No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetMonth Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(2);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetMonth SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetDay(int n, int n2) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetDay No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetDay Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(5);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetDay SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetHour(int n, int n2) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        int n3 = 0;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetHour No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        n3 = timestamp.getNanos();
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        if (this.m_Calendar.get(14) != 0 || (n3 /= 1000000) <= 0) break;
                        this.m_Calendar.set(14, n3);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetHour Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(11);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetHour SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetMinute(int n, int n2) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetMinute No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetMinute Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(12);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetMinute SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public byte GetSecond(int n, int n2) throws NullPointerException, SQLException {
        byte by;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetSecond No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetSecond Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            by = this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null") ? (byte)0 : (byte)this.m_Calendar.get(13);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetSecond SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return by;
    }

    public int GetMillisecond(int n, int n2) throws NullPointerException, SQLException {
        int n3;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetSecond No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            if (!this.m_Hashtable.containsKey(String.valueOf(n))) {
                switch (n2) {
                    case 91: {
                        Date date = ((CallableStatement)this.m_Statement).getDate(n);
                        if (date == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(date);
                        break;
                    }
                    case 92: {
                        Time time = ((CallableStatement)this.m_Statement).getTime(n);
                        if (time == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(time);
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = ((CallableStatement)this.m_Statement).getTimestamp(n);
                        if (timestamp == null) {
                            this.m_Hashtable.put(String.valueOf(n), "null");
                            return 0;
                        }
                        this.m_Calendar.clear();
                        this.m_Calendar.setTime(timestamp);
                        break;
                    }
                    default: {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetSecond Not a time column");
                        this.m_Error = new PbjdbcError(2, "Not a time column.");
                        throw new SQLException("Not a time column.");
                    }
                }
                this.m_Hashtable.put(String.valueOf(n), String.valueOf(n));
            }
            if (this.m_Hashtable.containsKey(String.valueOf(n)) && ((String)this.m_Hashtable.get(String.valueOf(n))).equals("null")) {
                n3 = 0;
            } else {
                n3 = this.m_Calendar.get(14);
                n3 *= 1000;
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetSecond SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return n3;
    }

    public boolean WasNull() throws NullPointerException, SQLException {
        boolean bl;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 2) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::WasNull No Callable Statement");
            this.m_Error = new PbjdbcError(2, "No Callable Statement.");
            throw new NullPointerException();
        }
        try {
            bl = ((CallableStatement)this.m_Statement).wasNull();
        }
        catch (SQLException sQLException) {
            this.m_Error = new PbjdbcError(sQLException);
            throw sQLException;
        }
        return bl;
    }

    public int Execute() {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute Cannot execute an empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot execute an empty statement.");
            return -1;
        }
        if (this.m_iTotalCursors > 0) {
            return this.ExecuteForOracleCursor();
        }
        try {
            if (((PreparedStatement)this.m_Statement).execute()) {
                this.m_ResultSet = this.m_Statement.getResultSet();
            } else {
                this.m_UpdateCount = new Integer(this.m_Statement.getUpdateCount());
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int Execute(String string) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType != 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute Cannot reassign a prepared statement");
            this.m_Error = new PbjdbcError(2, "Cannot reassign a prepared statement.");
            return -1;
        }
        this.m_szCommand = string;
        try {
            if (this.m_Statement.execute(string)) {
                this.m_ResultSet = this.m_Statement.getResultSet();
            } else {
                this.m_UpdateCount = new Integer(this.m_Statement.getUpdateCount());
            }
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        return 0;
    }

    public int ExecuteForOracleCursor() {
        try {
            ((CallableStatement)this.m_Statement).execute();
            Class<?> clazz = Class.forName("oracle.jdbc.OracleCallableStatement");
            Class[] classArray = new Class[]{Integer.TYPE};
            this.m_mthdCursor = clazz.getMethod("getCursor", classArray);
            Object[] objectArray = new Object[]{new Integer(this.m_iCurrentCursor)};
            this.m_ResultSet = (ResultSet)this.m_mthdCursor.invoke((Object)this.m_Statement, objectArray);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute for Oracle Cursor SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        catch (Exception exception) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute for Oracle Cursor Exception thrown");
            return -1;
        }
        --this.m_iTotalCursors;
        ++this.m_iCurrentCursor;
        return 0;
    }

    public int ExecuteAsync(int n) {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null || this.m_StatementType == 0) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Execute Cannot execute an empty statement");
            this.m_Error = new PbjdbcError(2, "Cannot execute an empty statement.");
            return -1;
        }
        try {
            this.m_Statement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::ExecuteAsync/setQueryTimeout SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        this.m_ExecResult = new PbjdbcExecuteThreadResult();
        this.m_ExecThread = new PbjdbcExecuteThread((PreparedStatement)this.m_Statement, this.m_ExecResult);
        this.m_ExecThread.start();
        return 0;
    }

    public int PeekExecuteAsync() {
        int n;
        if (this.m_ExecResult == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::PeekExecuteAsync Not executing asynchronously");
            this.m_Error = new PbjdbcError(2, "Not executing asynchronously.");
            return -1;
        }
        int n2 = this.m_ExecResult.GetExecState();
        if (n2 == 0) {
            n = 1;
        } else if (n2 == 1) {
            this.m_ResultSet = this.m_ExecResult.GetResultSet();
            this.m_ExecResult = null;
            this.m_ExecThread = null;
            n = 0;
        } else if (n2 == 2) {
            this.m_UpdateCount = this.m_ExecResult.GetUpdateCount();
            this.m_ExecResult = null;
            this.m_ExecThread = null;
            n = 0;
        } else {
            this.m_Error = this.m_ExecResult.GetError();
            this.m_ExecResult = null;
            this.m_ExecThread = null;
            n = -1;
        }
        return n;
    }

    public int Cancel() {
        if (this.m_Statement == null || this.m_ExecThread == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Cancel No Statement or ExecThread");
            this.m_Error = new PbjdbcError(2, "No Statement or ExecThread.");
            return -1;
        }
        try {
            this.m_Statement.cancel();
        }
        catch (SQLException sQLException) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Cancel SQLException thrown");
            PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
            PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
            PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
            this.m_Error = new PbjdbcError(sQLException);
            return -1;
        }
        this.m_ExecThread.destroy();
        this.m_ExecResult = null;
        this.m_ExecThread = null;
        return 0;
    }

    public PbjdbcRowSet GetRowSet() {
        this.m_Error = null;
        if (this.m_ResultSet == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetRowSet No ResultSet");
            this.m_Error = new PbjdbcError(2, "No ResultSet. The command did not produce any ResultSet.");
            return null;
        }
        PbjdbcRowSet pbjdbcRowSet = new PbjdbcRowSet(this.m_ResultSet);
        this.m_ResultSet = null;
        return pbjdbcRowSet;
    }

    public PbjdbcRowSet GetNextRowSet() throws NullPointerException, SQLException {
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        if (this.m_Statement == null) {
            PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetNextRowSet No statement");
            this.m_Error = new PbjdbcError(2, "No statement.");
            throw new NullPointerException();
        }
        boolean bl = false;
        if (this.m_iTotalCursors > 0) {
            try {
                Object[] objectArray = new Object[]{new Integer(this.m_iCurrentCursor)};
                this.m_ResultSet = (ResultSet)this.m_mthdCursor.invoke((Object)this.m_Statement, objectArray);
                bl = true;
                --this.m_iTotalCursors;
                ++this.m_iCurrentCursor;
            }
            catch (Exception exception) {
                PbjdbcTrace.TraceMessage("Java PbjdbcCommand::Fetch next result from Oracle Cursor Exception thrown");
            }
        } else {
            if (this.m_iTotalCursors == 0 && this.m_iCurrentCursor > 0) {
                return null;
            }
            try {
                int n = 0;
                do {
                    if (bl = this.m_Statement.getMoreResults()) continue;
                    try {
                        n = this.m_Statement.getUpdateCount();
                    }
                    catch (SQLException sQLException) {
                        PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetNextRowSet SQLException thrown");
                        PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
                        PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
                        PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
                        n = -1;
                    }
                    if (n < 0) continue;
                    this.m_UpdateCount = new Integer(n);
                } while (!bl && n >= 0);
                if (bl) {
                    this.m_ResultSet = this.m_Statement.getResultSet();
                }
            }
            catch (SQLException sQLException) {
                PbjdbcTrace.TraceMessage("Java PbjdbcCommand::GetNextRowSet SQLException thrown");
                PbjdbcTrace.TraceMessage("------->SQLState = " + sQLException.getSQLState());
                PbjdbcTrace.TraceMessage("------->ErrorCode = " + sQLException.getErrorCode());
                PbjdbcTrace.TraceMessage("------->Message = " + sQLException.getMessage());
                this.m_Error = new PbjdbcError(sQLException);
                throw sQLException;
            }
        }
        if (bl) {
            PbjdbcRowSet pbjdbcRowSet = new PbjdbcRowSet(this.m_ResultSet);
            this.m_ResultSet = null;
            return pbjdbcRowSet;
        }
        return null;
    }

    public int GetAffectedRows() {
        this.m_Error = null;
        if (this.m_UpdateCount == null) {
            return 0;
        }
        return this.m_UpdateCount;
    }

    public int GetStatementType() {
        return this.m_StatementType;
    }

    public int Reset() {
        if (this.m_StatementType != 0) {
            return -1;
        }
        this.m_szCommand = null;
        this.m_ResultSet = null;
        this.m_UpdateCount = null;
        this.m_Error = null;
        return 0;
    }

    public PbjdbcError GetLastError() {
        return this.m_Error;
    }
}

